<?php
/**
 * Template Name: Single Page Template - Videos
 *
 * Description: A page template that provides a key component of WordPress as a CMS
 * by meeting the need for a carefully crafted introductory page. The front page template
 * in Twenty Twelve consists of a page content area for adding text, images, video --
 * anything you'd like -- followed by front-page-only widgets in one or two columns.
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */

get_header(); ?>

	<div id="primary" class="site-content column">
		<div id="content" role="main">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

		<header class="entry-header">


			<h1 class="entry-title"><?php the_title(); ?></h1>

		</header><!-- .entry-header -->
        
        
        <div class="entry-content">
			<?php while ( have_posts() ) : the_post(); ?>
				<?php the_content( __( '', 'twentytwelve' ) ); ?>
			<?php endwhile; // end of the loop. ?>
        
<div class="video-wrapper">
<?php if( have_rows('videos') ): ?>
	<?php while( have_rows('videos') ): the_row(); 

		// vars
		$video_text = get_sub_field('video_text');
		$video_iframe = get_sub_field('video_iframe');
		$video_code = get_sub_field('video_code');
		?>
        
       <div class="video-list">                
        <?php echo $video_text; ?>
        <?php echo $video_iframe; ?>
        <textarea><?php echo $video_code; ?></textarea>

        </div>
	<?php endwhile; ?>
<?php endif; ?>
</div>

</div>
</article>

		</div><!-- #content -->
	</div><!-- #primary -->

<script type="text/javascript">
$(document).ready(function() {
		$(".fancybox").fancybox();
	});
	
jQuery('#type').on("input", function() {
    jQuery(".change").text(this.value);
});
  
jQuery('#hit').click(function(event) {
     var username = jQuery('#type').val();

	jQuery('.link-change a').each(function() {
     Query(this).attr("href", function(index, old) {
         return old.replace('YOURNAME', username);
      });
 });
 
 
// jQuery( ".link-change" ).wrapInner(function() {
//  return "<textarea></textarea>";
//});

});	   
</script>



<?php get_sidebar(); ?>
<?php get_footer(); ?>