<?php
/**
 * Template Name: Single Page CLN Template - Links
 *
 * Description: A page template that provides a key component of WordPress as a CMS
 * by meeting the need for a carefully crafted introductory page. The front page template
 * in Twenty Twelve consists of a page content area for adding text, images, video --
 * anything you'd like -- followed by front-page-only widgets in one or two columns.
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */

get_header(); ?>

	<div id="primary" class="site-content column">
		<div id="content" role="main">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

		<header class="entry-header">


			<h1 class="entry-title"><?php the_title(); ?></h1>

		</header><!-- .entry-header -->
        
        
        <div class="entry-content">
			<?php while ( have_posts() ) : the_post(); ?>
				<?php the_content( __( '', 'twentytwelve' ) ); ?>
			<?php endwhile; // end of the loop. ?>
        
<div class="id-text">
    <input id="type" type="text" />
    <input type="text" id="finalurl" value="Hello" style="position: absolute;left: -999999999999px;">
</div>

<div class="links-list">
<?php if( have_rows('Links') ): $i = 1;?>
	<?php while( have_rows('Links') ): the_row(); 

		// vars
		$text_1 = get_sub_field('link_title');
		$text_2 = get_sub_field('link_url');
		$text_3 = get_sub_field('subdomain_url');
		$http_text = "https://";
	    if( $text_1==trim("Direct Checkout Link:") || $text_1=="$17 Discounted Product Link ($20 OFF) :" || $text_1=="$7 Discounted Product Link (With $10 Rebill Monthly With Commission):"  ) {
			$http_text = "https://";
			?>
		<p class="center-week link-week-style"><strong><?php echo $text_1; ?><br>
        <span class="link-color"><?php echo $http_text.$text_3; ?><span class="change">XXXXX</span><?php echo $text_2; ?><span></strong></p>	
	<?php
		}else{
		?>
		<p class="center-week link-week-style"><strong><?php echo $text_1; ?><br>
            <span class="link-color" id="link-<?php echo $i; ?>"><?php echo $http_text; ?>hop.clickbank.net/?affiliate=<span class="change">XXXXX</span>&vendor=edelixir<?php echo $text_2; ?></span><button onclick="copyFunction(<?php echo $i; ?>)" class="copyBtn">Copy URL</button><span class="copy-confirm" id="copied-<?php echo $i; ?>"></span></strong></p>
		<?php } $i++;?>
            
	<?php endwhile; ?>
<?php endif; ?>
</div>

 <?php the_field('links_additional_text'); ?>

</div>

</article>

		</div><!-- #content -->
	</div><!-- #primary -->

<script type="text/javascript">
    
    jQuery(document).ready(function() {
        jQuery(".link-week-style button").hide();
    });
    jQuery('#type').on("input", function() {
        jQuery(".change").text(this.value);
        if(jQuery(this).val() == "" || jQuery(this).val() == null) {
            jQuery(".link-week-style button").hide();
        } else {
            jQuery(".link-week-style button").show();
        }
    });
    function copyFunction(link) {
        /* Get the text field */
        var copyText = "";
        
        //set hidden input final url value to url composed
        var fUrl = jQuery("#link-"+link).text();
        jQuery("#finalurl").val(fUrl);
        jQuery("finalurl").trigger("change");
        
        copyText = document.getElementById("finalurl");
        console.log(copyText);
        
        /* Select the text field */
        copyText.select();
        copyText.setSelectionRange(0, 99999); /*For mobile devices*/
        
        /* Copy the text inside the text field */
        document.execCommand("copy");
        
        /* Alert the copied text */
        jQuery("#copied-"+link).text("Url copied to clipboard.");
        setTimeout(
          function() 
          {
            jQuery("#copied-"+link).text("");
          }, 3000);
    }
    

</script>
<style>
    .copyBtn {
        margin-left: 10px;
        border-radius: 20px;
        background: whitesmoke;
        border-bottom: 2px solid #e4e4e4 !important;
        border: none;
        padding: 5px 10px;
        font-weight: bold;
        font-family: open sans !important;
    }
    span.copy-confirm {
        font-size: 12px;
        color: darkgray;
        padding-left: 10px;
    }
</style>

<?php get_sidebar(); ?>
<?php get_footer(); ?>